/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.handlers;

import com.ibm.hwmca.base.rsf.handlers.BaseRsfHandlersErrorIds;
import com.ibm.hwmca.base.rsf.handlers.RetainUtils;
import com.ibm.hwmca.base.rsf.handlers.ZPapHandler;
import com.ibm.hwmca.base.rsf.requests.BaseRsfResultDetails;
import com.ibm.hwmca.base.rsf.requests.SdPapRequestContent;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.FrameworkLogAttributes;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.ProblemReportRequestBody;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SdPapHandler
implements BaseRsfHandlersErrorIds {
    private static String TRACE_MASKF = "XSSISD F";
    private static String TRACE_MASKT = "XSSISD T";
    private static String TRACE_MASKD = "XSSISD D";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "SdPapHandler");
    private static FrameworkLogAttributes infoLog = FrameworkLogAttributes.INFO_LOG;
    private static String EBCDIC = "Cp500";
    private static final byte READ_COMFILE = 1;
    private static final byte WRITE_RESPONSE = 2;
    private static final byte DISCONNECT = 126;
    private static int defaultTimeout = 900000;
    private ZPapHandler base;
    private SdPapRequestContent sdContent;
    private BaseRsfResultDetails zresponse;
    private int rc = 0;

    public SdPapHandler(ZPapHandler baseHandler, BaseRsfResultDetails zresponse, ProblemReportRequestBody body) {
        Trace.trace(TRACE_MASKT, "<>SdPapHandler::SdPapHandler()");
        this.sdContent = new SdPapRequestContent(body);
        this.base = baseHandler;
        this.zresponse = zresponse;
    }

    public int getResult() {
        return this.rc;
    }

    public boolean processCommand(byte[] data) throws IOException {
        Trace.trace(TRACE_MASKT, "->SdPapHandler::processCommand()");
        byte command = data[0];
        byte[] discResponse = new byte[41];
        discResponse[1] = 41;
        discResponse[2] = SdPapRequestContent.assignByte(254);
        switch (command) {
            case 1: {
                Trace.trace(TRACE_MASKF, "SdPapHandler::processCommand() - read Comfile");
                if (data.length < 27) {
                    this.logRetainError("Invalid length on READ_COMFILE request from service director PAP.  Length found=" + data.length);
                    RetainUtils.sendBytes(this.base.bout, discResponse, discResponse.length, true);
                    this.rc = 99;
                    return false;
                }
                byte[] header = new byte[22];
                int i = 0;
                while (i < 22) {
                    header[i] = data[i + 5];
                    ++i;
                }
                byte[] comfile = this.sdContent.format(header);
                RetainUtils.sendBytes(this.base.bout, comfile, comfile.length, true);
                return true;
            }
            case 2: {
                Trace.trace(TRACE_MASKF, "SdPapHandler::processCommand() - write response");
                if (data.length < 53) {
                    this.logRetainError("Invalid length on service director PAP write response. Length found=" + data.length);
                    RetainUtils.sendBytes(this.base.bout, discResponse, discResponse.length, true);
                    this.rc = 99;
                    return false;
                }
                byte[] papResponse = new byte[41];
                papResponse[1] = 41;
                papResponse[2] = SdPapRequestContent.assignByte(130);
                int i = 3;
                while (i < 29) {
                    papResponse[i] = data[i - 2];
                    ++i;
                }
                try {
                    String pmh = new String(data, 48, 5, EBCDIC);
                    Trace.trace(TRACE_MASKD, "SdPapHandler::processCommand() - write response pmh=" + pmh);
                    this.zresponse.getRsfResultDetails().putAttribute("pmh", pmh);
                }
                catch (UnsupportedEncodingException e) {
                    this.logEncodingError();
                }
                RetainUtils.sendBytes(this.base.bout, papResponse, papResponse.length, true);
                return true;
            }
            case 126: {
                Trace.trace(TRACE_MASKF, "SdPapHandler::processCommand() - disconnect");
                if (data.length < 11) {
                    this.logRetainError("Invalid length on service director PAP disconnect.  Length found=" + data.length);
                    RetainUtils.sendBytes(this.base.bout, discResponse, discResponse.length, true);
                    return false;
                }
                String messageType = "E";
                String completionCode = "000";
                String message = "";
                try {
                    messageType = new String(data, 10, 1, EBCDIC);
                    completionCode = new String(data, 7, 3, EBCDIC);
                    message = new String(data, 12, data.length - 12, EBCDIC);
                }
                catch (UnsupportedEncodingException e) {
                    this.logEncodingError();
                }
                Trace.trace(TRACE_MASKD, "SdPapHandler.processCommand() completion code & message=" + completionCode + messageType + " " + message);
                String retainRc = new String(data, 4, 7);
                this.zresponse.getRsfResultDetails().putAttribute("return code", retainRc);
                this.zresponse.getRsfResultDetails().putAttribute("error message", message);
                if (!messageType.equals("I")) {
                    String logInfo = "Error in RETAIN Handler on disconnect for service director PAP:" + retainRc + " " + message;
                    this.logRetainError(logInfo);
                    this.rc = 99;
                } else {
                    this.rc = 0;
                }
                RetainUtils.sendBytes(this.base.bout, discResponse, discResponse.length, true);
                return false;
            }
        }
        String errorMsg = "Invalid command from service director PAP:" + command;
        this.logRetainError(errorMsg);
        this.rc = 99;
        return false;
    }

    private void logRetainError(String errorMsg) {
        this.rc = 999;
        this.zresponse.setReasonCode(3);
        Trace.trace(TRACE_MASKF, "SdPapHandler: " + errorMsg);
        FrameworkLog retainLog = new FrameworkLog(logInfo, 28530);
        retainLog.add(errorMsg);
        retainLog.log(infoLog);
    }

    private void logEncodingError() {
        String errorMsg = "SdPapHandler: Invalid character encoding";
        Trace.trace(TRACE_MASKF, errorMsg);
        FrameworkLog retainLog = new FrameworkLog(logInfo, 28671);
        retainLog.add(errorMsg);
        retainLog.log(infoLog);
    }
}

